/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power;

import io.github.apace100.origins.power.ActiveCooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.HudRender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class FireProjectilePower
extends ActiveCooldownPower {
    private final EntityType<?> entityType;
    private final int projectileCount;
    private final float speed;
    private final float divergence;
    private final SoundEvent soundEvent;
    private final CompoundNBT tag;

    public FireProjectilePower(PowerType<?> type, PlayerEntity player, int cooldownDuration, HudRender hudRender, EntityType<?> entityType, int projectileCount, float speed, float divergence, SoundEvent soundEvent, CompoundNBT tag) {
        super(type, player, cooldownDuration, hudRender, null);
        this.entityType = entityType;
        this.projectileCount = projectileCount;
        this.speed = speed;
        this.divergence = divergence;
        this.soundEvent = soundEvent;
        this.tag = tag;
    }

    @Override
    public void onUse() {
        if (this.canUse()) {
            this.fireProjectiles();
            this.use();
        }
    }

    private void fireProjectiles() {
        if (this.soundEvent != null) {
            this.player.field_70170_p.func_184148_a(null, this.player.func_226277_ct_(), this.player.func_226278_cu_(), this.player.func_226281_cx_(), this.soundEvent, SoundCategory.NEUTRAL, 0.5f, 0.4f / (this.player.func_70681_au().nextFloat() * 0.4f + 0.8f));
        }
        if (!this.player.field_70170_p.field_72995_K) {
            for (int i = 0; i < this.projectileCount; ++i) {
                this.fireProjectile();
            }
        }
    }

    private void fireProjectile() {
        if (this.entityType != null) {
            Entity entity = this.entityType.func_200721_a(this.player.field_70170_p);
            if (entity == null) {
                return;
            }
            Vector3d rotationVector = this.player.func_70040_Z();
            Vector3d spawnPos = this.player.func_213303_ch().func_72441_c(0.0, (double)this.player.func_213316_a(this.player.func_213283_Z(), this.player.func_213305_a(this.player.func_213283_Z())), 0.0).func_178787_e(rotationVector);
            entity.func_70012_b(spawnPos.func_82615_a(), spawnPos.func_82617_b(), spawnPos.func_82616_c(), this.player.field_70125_A, this.player.field_70177_z);
            if (entity instanceof ProjectileEntity) {
                if (entity instanceof DamagingProjectileEntity) {
                    DamagingProjectileEntity explosiveProjectileEntity = (DamagingProjectileEntity)entity;
                    explosiveProjectileEntity.field_70232_b = rotationVector.field_72450_a * (double)this.speed;
                    explosiveProjectileEntity.field_70233_c = rotationVector.field_72448_b * (double)this.speed;
                    explosiveProjectileEntity.field_70230_d = rotationVector.field_72449_c * (double)this.speed;
                }
                ProjectileEntity projectile = (ProjectileEntity)entity;
                projectile.func_212361_a((Entity)this.player);
                projectile.func_234612_a_((Entity)this.player, this.player.field_70125_A, this.player.field_70177_z, 0.0f, this.speed, this.divergence);
            } else {
                float f = -MathHelper.func_76126_a((float)(this.player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.player.field_70125_A * ((float)Math.PI / 180)));
                float g = -MathHelper.func_76126_a((float)(this.player.field_70125_A * ((float)Math.PI / 180)));
                float h = MathHelper.func_76134_b((float)(this.player.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.player.field_70125_A * ((float)Math.PI / 180)));
                Vector3d vec3d = new Vector3d((double)f, (double)g, (double)h).func_72432_b().func_72441_c(this.player.func_70681_au().nextGaussian() * (double)0.0075f * (double)this.divergence, this.player.func_70681_au().nextGaussian() * (double)0.0075f * (double)this.divergence, this.player.func_70681_au().nextGaussian() * (double)0.0075f * (double)this.divergence).func_186678_a((double)this.speed);
                entity.func_213317_d(vec3d);
                Vector3d playerVelo = this.player.func_213322_ci();
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(playerVelo.field_72450_a, this.player.func_233570_aj_() ? 0.0 : playerVelo.field_72448_b, playerVelo.field_72449_c));
            }
            if (this.tag != null) {
                CompoundNBT mergedTag = entity.func_189511_e(new CompoundNBT());
                mergedTag.func_197643_a(this.tag);
                entity.func_70020_e(mergedTag);
            }
            this.player.field_70170_p.func_217376_c(entity);
        }
    }
}

